/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.visio.VWWizardHelper;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class VWFileSelectionPanel
extends JPanel
implements IVWWizardPanel,
ActionListener {
    private static final int MIN_LOCATION_PADDING = 50;
    private static final int MAX_LOCATION_PADDING = 250;
    private JDialog m_parentDialog = null;
    private FileDialog m_openFileDialog = null;
    private VWWizardHelper m_wizardHelper = null;
    private JTextField m_textField = null;
    private JButton m_browseButton = null;
    private JRadioButton m_replaceExistingRadioButton = null;
    private JRadioButton m_editWorkflowNamesRadioButton = null;
    private JTextField m_locationPaddingTextField = null;

    public VWFileSelectionPanel(JDialog parentDialog, VWWizardHelper wizardHelper) {
        this.m_parentDialog = parentDialog;
        this.m_wizardHelper = wizardHelper;
        this.createControls();
    }

    public void checkForErrors() throws Exception {
        this.m_wizardHelper.setVisioFile(this.m_textField.getText());
        this.m_wizardHelper.setShouldRenameNewWorkflows(this.m_editWorkflowNamesRadioButton.isSelected());
        String locationPaddingString = this.m_locationPaddingTextField.getText();
        int nLocationPadding = -1;
        try {
            nLocationPadding = Integer.parseInt(locationPaddingString);
        }
        catch (Exception ex) {
            throw new VWException("vw.toolkit.design.visio.invalidLocationPadding", "Please specify a valid step and annotation spacing value: \"{0}\".", locationPaddingString);
        }
        if (nLocationPadding < 50 || nLocationPadding > 250) {
            throw new VWException("vw.toolkit.design.visio.outsideLocationPaddingRange", "Please specify a valid step and annotation spacing value between {0} and {1}.", new Integer(50), new Integer(250));
        }
        this.m_wizardHelper.setLocationPadding(nLocationPadding);
    }

    public String getHelpTopic() {
        return "file_selection";
    }

    public String getUniqueIdentifier() {
        return "FILE_SELECTION";
    }

    public String getInstructions() {
        return VWResource.s_fileSelectionInstructions;
    }

    public String getTitle() {
        return VWResource.s_fileSelectionTitle;
    }

    public void initialize() throws Exception {
        this.m_locationPaddingTextField.setText(Integer.toString(this.m_wizardHelper.getLocationPadding()));
    }

    public void releaseResources() {
        this.m_parentDialog = null;
        this.m_openFileDialog = null;
        this.m_textField = null;
        if (this.m_browseButton != null) {
            this.m_browseButton.removeActionListener(this);
            this.m_browseButton = null;
        }
        this.m_replaceExistingRadioButton = null;
        this.m_editWorkflowNamesRadioButton = null;
        this.removeAll();
    }

    public boolean getDisplayState() {
        return true;
    }

    public void setDisplayState(boolean bState) {
    }

    public boolean getEnableFinishButton() {
        return false;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_browseButton)) {
                if (this.m_openFileDialog == null && this.m_parentDialog != null) {
                    this.m_openFileDialog = new FileDialog((Frame)this.m_parentDialog.getParent());
                    this.m_openFileDialog.setMode(0);
                    this.m_openFileDialog.setTitle(VWResource.s_open);
                }
                if (this.m_openFileDialog != null) {
                    this.m_openFileDialog.setFile("*.vdx");
                    this.m_openFileDialog.setVisible(true);
                    String fileToOpen = this.m_openFileDialog.getFile();
                    if (fileToOpen != null) {
                        File file = new File(this.m_openFileDialog.getDirectory() + fileToOpen);
                        this.m_textField.setText(file.toString());
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            this.add((Component)new JLabel(VWResource.s_sourceFilePath), gbCons);
            ++gbCons.gridy;
            this.m_textField = new JTextField();
            this.m_textField.setName("m_textField_VWFileSelectionPanel");
            this.add((Component)this.m_textField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(0, 5, 0, 0);
            this.m_browseButton = new JButton(VWResource.s_browse + "...");
            this.m_browseButton.setName("m_browseButton_VWFileSelectionPanel");
            this.m_browseButton.addActionListener(this);
            this.add((Component)this.m_browseButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.2;
            gbCons.insets = new Insets(0, 5, 0, 0);
            this.add((Component)new JLabel(" "), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridwidth = 0;
            this.add((Component)new JLabel(VWResource.s_workflowsWillBeAddedToTheCollection), gbCons);
            ButtonGroup buttonGroup = new ButtonGroup();
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 15, 0, 0);
            this.m_editWorkflowNamesRadioButton = new JRadioButton(VWResource.s_editNewWorkflowNamesToMakeThemUnique);
            this.m_editWorkflowNamesRadioButton.setName("m_editWorkflowNamesRadioButton_VWFileSelectionPanel");
            buttonGroup.add(this.m_editWorkflowNamesRadioButton);
            this.m_editWorkflowNamesRadioButton.setSelected(true);
            this.add((Component)this.m_editWorkflowNamesRadioButton, gbCons);
            ++gbCons.gridy;
            this.m_replaceExistingRadioButton = new JRadioButton(VWResource.s_replaceWorkflowsWithTheSameName);
            this.m_replaceExistingRadioButton.setName("m_replaceExistingRadioButton_VWFileSelectionPanel");
            buttonGroup.add(this.m_replaceExistingRadioButton);
            this.add((Component)this.m_replaceExistingRadioButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.2;
            gbCons.insets = new Insets(0, 5, 0, 0);
            this.add((Component)new JLabel(" "), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weighty = 0.0;
            this.add((Component)this.getScaleFactorPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.6;
            gbCons.insets = new Insets(0, 5, 0, 0);
            this.add((Component)new JLabel(" "), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getScaleFactorPanel() {
        try {
            JPanel childPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.insets = new Insets(5, 5, 5, 5);
            childPanel.add((Component)new JLabel(VWResource.s_stepAndAnnotationSpacing), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.2;
            this.m_locationPaddingTextField = new JTextField();
            this.m_locationPaddingTextField.setName("m_locationPaddingTextField_VWFileSelectionPanel");
            childPanel.add((Component)this.m_locationPaddingTextField, gbCons);
            ++gbCons.gridx;
            gbCons.weightx = 0.8;
            childPanel.add((Component)new JLabel(" "), gbCons);
            return childPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

